#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Name.h"

PrimaryKeysRect::PrimaryKeysRect(QRectF& rect, QGraphicsItem * parent) : QGraphicsRectItem(parent)
{
	double gap = ((Table*)(this->parentItem()))->GetNameRect()->boundingRect().height();
	this->rect = QRectF(rect.x()+1, rect.y()+1+gap, rect.width()-2, (rect.height()-2)/3);

	this->setRect(this->rect);

	QString buffer("PrimaryKey");
	QString number;
	number.sprintf("%d", (this->primaryKeys.count()+1));
	buffer = buffer + (((Table*)(this->parentItem()))->GetNameRect()->GetName()->toPlainText())[((((Table*)(this->parentItem()))->GetNameRect()->GetName()->toPlainText()).size())-1] + number;
		
	QRectF rectf = this->boundingRect();
	PrimaryKey* primaryKey = new PrimaryKey(rectf, this->primaryKeys.count(), buffer, this);

	this->primaryKeys << primaryKey;
}

PrimaryKeysRect::~PrimaryKeysRect()
{
}

void PrimaryKeysRect::InsertPrimaryKey()
{
	QString buffer("PrimaryKey");
	QString number;

	number.sprintf("%d", (this->primaryKeys.count()+1));
	buffer = buffer + (((Table*)(this->parentItem()))->GetNameRect()->GetName()->toPlainText())[((((Table*)(this->parentItem()))->GetNameRect()->GetName()->toPlainText()).size())-1] + number;

	QRectF rectf = this->boundingRect();
	PrimaryKey* primaryKey = new PrimaryKey(rectf, this->primaryKeys.count(), buffer, this);

	this->primaryKeys << primaryKey;

	this->SetRect(1);
}

void PrimaryKeysRect::InsertPrimaryKey(QString name)
{
	QRectF rectf = this->boundingRect();
	PrimaryKey* primaryKey = new PrimaryKey(rectf, this->primaryKeys.count(), name, this);

	this->primaryKeys << primaryKey;

	this->SetRect(1);
}

void PrimaryKeysRect::InsertPrimaryKey(QStringList& foreignKeyList)
{
	for( int i=0; i<foreignKeyList.count(); i++){

		QRectF rect = this->boundingRect();
		PrimaryKey* primaryKey = new PrimaryKey(rect, this->primaryKeys.count(), foreignKeyList[i], this);
		
		this->primaryKeys << primaryKey;
		
		//((Table*)(this->parentItem()))->GetAttributesRect()->SetPosition(1);
		
		this->SetRect(1);
	}
}

void PrimaryKeysRect::DeletePrimaryKey(QStringList& foreignKeyList, QList<PrimaryKey*>& list)
{
	for( int i=0; i<this->primaryKeys.count(); i++){
		
		for(int j=0; j< foreignKeyList.count(); j++){
			
			if( foreignKeyList[j].contains("(FK)", Qt::CaseInsensitive) == false ){
				foreignKeyList[j] = foreignKeyList[j] + "(FK)";
			}
			
			if( (this->primaryKeys)[i]->toPlainText() == foreignKeyList[j] ){
				list << this->primaryKeys.takeAt(i);
			}
		}
	}
}

void PrimaryKeysRect::DeletePrimaryKey()
{
	PrimaryKey* buffer;

	if( this->primaryKeys.count() == 1 ){
		this->primaryKeys.last()->setPlainText("");
	}
	
	else if( this->primaryKeys.count() > 1 ){
		buffer = this->primaryKeys.takeLast();
		
		delete buffer;

		this->SetRect(0);
	}
}

void PrimaryKeysRect::DeletePrimaryKey(PrimaryKey* primaryKey)
{
	int i=0;

	while( i<this->primaryKeys.count() && ((this->primaryKeys)[i]->pos() != primaryKey->pos())){
		i++;
	}

	PrimaryKey* buffer = 0;

	if( i < this->primaryKeys.count() ){
		buffer = (this->primaryKeys).takeAt(i);
	}

	if ( buffer != 0 ){
		delete buffer;
	}
}

void PrimaryKeysRect::SetRect(int state)
{
	double buffer = 16;		//  ũ⸦ ø offset
	
	if( state == 0 ){
		buffer = -buffer;
	}
	
	this->rect = QRectF(this->boundingRect().x(), this->boundingRect().y(), this->boundingRect().width(), 
				this->boundingRect().height() + buffer);
	this->setRect(rect);
	
	((Table*)(this->parentItem()))->GetAttributesRect()->SetPosition(state);
	((Table*)(this->parentItem()))->SetPosition(state);
	//((Table*)(((PrimaryKeysRect*)(this->parentItem()))->parentItem()))->SetPosition(1);
}
